<?php

function changeUsers()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $users = ParamGet($sock, "security");
   $users = $users->security->user;
   $users = sort_nested_arrays($users, ["index" => "desc"]);

   if (isset($object[0])) {
      $arr = $object;
      $user_id = $arr[4] + 1;
      $user_index = 0;
      foreach ($users as $user) {
         if ($user->id == $user_id) {
            dispatchServer($sock, $user, $user_index, $arr);
         }
         $user_index += 1;
      }
   }
   socket_close($sock);
}

function changeChannels()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $users = ParamGet($sock, "security");
   $users = $users->security->user;
   $users = sort_nested_arrays($users, ["index" => "desc"]);

   $policy_users = $object;

   foreach ($policy_users as $policy_user) {
      $status = false;
      $storeUser = (object) [];
      $userIndex = 0;
      foreach ($users as $user) {
         if ($user->index == $policy_user[4]) {
            $storeUser = $user;
            $userIndex = $storeUser->index;
            $status = true;
            break;
         }
      }
      if ($status) {
         $count_block = 0;
         foreach ($policy_user as $block) {
            if ($count_block < 4) {
               if (isset($storeUser->deny)) {
                  saveUserPolicyCamera($sock, $block, $count_block, $storeUser, "read");

                  saveUserPolicyCamera($sock, $block, $count_block, $storeUser, "write");

                  saveUserPolicyCamera($sock, $block, $count_block, $storeUser, "play");

                  saveUserPolicyCamera($sock, $block, $count_block, $storeUser, "ptz");

                  saveUserPolicySound($sock, $block, $count_block, $storeUser, "soundRead", "read");

                  saveUserPolicySound($sock, $block, $count_block, $storeUser, "soundPlay", "play");
               } else {
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.sound.[" . $count_block . "].index",
                     $count_block
                  );
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.camera.[" . $count_block . "].index",
                     $count_block
                  );

                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.camera.[" . $count_block . "].read",
                     $block["read"]
                  );
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.camera.[" . $count_block . "].write",
                     $block["write"]
                  );
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.camera.[" . $count_block . "].play",
                     $block["play"]
                  );
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.camera.[" . $count_block . "].ptz",
                     $block["ptz"]
                  );

                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.sound.[" . $count_block . "].read",
                     $block["soundRead"]
                  );
                  ParamSetInt(
                     $sock,
                     "security.user.[" . $userIndex . "].deny.sound.[" . $count_block . "].play",
                     $block["soundPlay"]
                  );
               }
            }
            $count_block++;
         }
      }
   }

   socket_close($sock);
   return true;
}
function changeChannel($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $arr = ParamGet($sock, "video");
   $audio = ParamGet($sock, "audio");

   $arr = $arr->video->input;
   $audio = $audio->audio->input;

   $itemVideo = getItem($arr, $id);
   $itemAudio = getItem($audio, $id);
   if (isset($arr)) {
      if (isset($object[0]["connect"])) {
         saveVideo($sock, $object[0]["connect"], $id, $itemVideo->read, "read");
      }
      if (isset($object[0]["settings"])) {
         saveVideo($sock, $object[0]["settings"], $id, $itemVideo->write, "write");
      }
      if (isset($object[0]["archive"])) {
         saveVideo($sock, $object[0]["archive"], $id, $itemVideo->play, "play");
      }
      if (isset($object[0]["manage"])) {
         saveVideo($sock, $object[0]["manage"], $id, $itemVideo->ptz, "ptz");
      }
      if (isset($object[0]["readSound"])) {
         saveAudio($sock, $object[0]["readSound"], $id, $itemAudio->read, "read");
      }
      if (isset($object[0]["playSound"])) {
         saveAudio($sock, $object[0]["playSound"], $id, $itemAudio->play, "play");
      }
   }

   socket_close($sock);
}
function changeAccess()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $users = ParamGet($sock, "security");

   $users = $users->security->user;
   $users = sort_nested_arrays($users, ["index" => "desc"]);
   foreach ($object as $export_user) {
      $user_index = 0;
      foreach ($users as $user) {
         if ($export_user["index"] == $user->index && $export_user["access"] * 10 != $user->accesslevel) {
            ParamSetInt($sock, "security.user.[$user_index].accesslevel", $export_user["access"] * 10);
         }
         $user_index++;
      }
   }

   socket_close($sock);
}
function changeServer()
{
   $sock = Login();

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $words = ["read", "write", "play", "ptz"];
   foreach ($words as $word) {
      save($sock, $object, $word);
   }
   socket_close($sock);
}
